

#ifndef __jabber_meeting_account_wapi_sync_h__
#define __jabber_meeting_account_wapi_sync_h__

#include "JabberMeetingAccountSync.h"
#include "csfunified/framework/UnifiedFactory.h"
#include "WapiClient/WapiclientInterface.h"
#include "apcom/apcom.h"
#include "apcom/apcomlib.h"
#include "csf/logger/CSFLogger.hpp"
#include "include/JabberWerxCPP.h"
#include "LoginMgr/LoginMgrInterface.h"
#include "wapiparse.h"

namespace CSFUnified
{
    class JabberMeetingAccountWapiSync : public IDefWapiEvent, public IJabberMeetingAccountSync
    {
    public:
        JabberMeetingAccountWapiSync(IJabberMeetingAccountEvent * pEvent);
        virtual ~JabberMeetingAccountWapiSync();
        
        virtual void start();
        virtual void stop();
        virtual void syncAllSite();
        virtual void getDefaultSite();
        virtual void setDefaultSite(SMART_PTR_NS::shared_ptr<MeetingSiteImpl> site, std::string sessionTicket, long keepAliveTime);
        virtual void deleteSite(std::string siteUrl);
        virtual void updateAllSite(std::string defaultSiteUrl, MeetingSiteImpl* addedSite, std::string deletedSiteUrl) {}

        //Wapi Event;
        virtual stdapi OnSink(AT::CTString const& xmlResponse, WapiCallType nReqType, WAPIMESSAGE& wmsg, AT::CTString const& strUserData);
        virtual stdapi QueryInterface(conREFIID riid, void** ppvObject) {return 0;}
        virtual stdapi QueryInterfaceEx(const tchar* pszServiceGroup, const tchar* pszServiceName, void** ppvObject) {return 0;}
        virtual ConUint32 stdcall_convertion AddRef(void) {return 0;}
        virtual ConUint32 stdcall_convertion Release(void) {return 0;}
        
        
    private:
        //WapiDelegateEvent
        void onGetAllAccounts(AT::CTString xmlRespond);
        void onDefaultAccount(AT::CTString xmlRespond, bool isGetDefault);
        bool parseMeetingSite(SMART_PTR_NS::shared_ptr<MeetingSiteImpl>& site, WbxSiteInfo& info);
        bool checkSiteProperty(int siteType, bool& isEditable, bool& isDeletable);
        JABBER_MEETING_ACCOUNT_ERROR_CODE getErrorCode(std::string &errMsg, std::string &strReason);
        void decodeWapiPassword(std::string strInput, std::string& strOutput);
		void addSite2List(SMART_PTR_NS::shared_ptr<MeetingSiteImpl>& site, std::list<SMART_PTR_NS::shared_ptr<MeetingSiteImpl> >& siteList);
        
        
    private:
        IJabberMeetingAccountEvent& m_event;
        CConComPtr<IWapiCli> m_pWapiMgr;
        unsigned int m_iCookie;
        WAPIHANDLE m_wapiHandle;
    };
}

#endif//__jabber_meeting_account_wapi_sync_h__
